DROP PROCEDURE [hips].[IhiLookupAlertInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Create date: 11 Oct 2012
-- Description:   Inserts a new record into the IhiLookupAlert Table
-- =============================================
CREATE PROCEDURE [hips].[IhiLookupAlertInsert] 
(
	@PatientMasterId INT,
	@Message VARCHAR(512),
	@Request XML = NULL,
	@Response XML = NULL,
	@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
	
    DECLARE @intErrorCode INT
		,@IhiLookupAlertId INT

    SET @intErrorCode = 0

    INSERT
     INTO [hips].IhiLookupAlert
             ( PatientMasterId ,
               Message ,
               Request ,
               Response ,
               DateModified ,
               UserModified ,
               DateCreated ,
               UserCreated
             )
     VALUES  ( @PatientMasterId , -- PatientMasterId - int
               @Message , -- Message - varchar(512)
               @Request , -- Request - xml
               @Response , -- Response - xml
               GETDATE() , -- DateModified - datetime
               @UserModified , -- UserModified - varchar(256)
               GETDATE() , -- DateCreated - datetime
               @UserModified  -- UserCreated - varchar(256)
             )

    SELECT @intErrorCode = @@ERROR 
		, @IhiLookupAlertId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [IhiLookupAlertId]
		 , [PatientMasterId]
		 , [Message]
		 , [Request]
         , [Response]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         FROM [hips].[IhiLookupAlert]
         WHERE [IhiLookupAlertId] = @IhiLookupAlertId
    END

    RETURN(@intErrorCode)
END
GO

